function [ P , J ] = Std_to_Tri( T , S )
%Map points of std element onto a triangle and output map's Jacobian.
%   The std element is convex hull of <0,e1,e2> in plane. We first map the
%   standard element onto the convex hull of <e1,e2,e3>, then map this by
%   standard barycenter transformation onto 1\times Tri. We finally project
%   back down onto Tri.  T is a (3 x 2) array for x-y vertex columns.  S is
%   a (numpt x 2) array.  P is (numpt x 2) array for image and J is
%   jacobian of this composite linear map.


S = S';
%Map from <0,e1,e2> --> <e1,e2,e3>
%(s,t,0) --> (s,t,1-s-t)
clear r1 r2
r1 = [[1 0 -1]];
r2 = [[0 1 -1]];

A = [r1;r2]';
S1 = A*S;
S1(3,:) = S1(3,:) + 1;

%Map onto 1\times Tri
%   Note: Linear map, the columns of matrix are image of e1,e2,e3.  If
%   start with their convex hull -- bc linear maps send convex hulls to
%   convex hulls -- we map to convex hull of 1\times p_{j} each j, is
%   1\times Tri and that's logic.
%[[ 1   1   1 ][[x]
% [p1x p2x p3x] [y]
% [p1y p2y p3y]][z]]
clear r1 r2
r1 = [[1 1 1]];

B = [r1;T'];
S2 = B*S1;

%Map onto Tri
%[[ 0   1   0 ]
% [ 0   0   1 ]]

clear r1
r1 = [[0 1 0]];
r2 = [[0 0 1]];

C = [r1;r2];
P = C*S2;

%Format right way
clear r1 r2
P = P';

%Calculate the Jacobian
J = det(C*B*A);
J = abs(J);
end

